#!/usr/bin/python

#    This file is part of EXEQ.
#
#    EXEQ is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.
# 
# Copyright (C) Michael Fromme, 2016-2017

__doc__ = """
Create a png or x3d file for EXED (E,q)-range visualisation with python:
usage:
    pyexe.py parameterfile [result_directory]
Parameters are read from a text file,
the result file name are result_directory + inst.png and maps.png respective
"""

import os
import sys
# import volume
from geometry import *
from units import *
# from filters import *
# from persistence_agg import Kernel

### reading float values from file

def read_f(f):
    return float(f.readline().rstrip())

def read_fa(f):
    a = []
    for i in f.readline().rstrip().split():
        a.append(float(i))
    return np.array(a)

def checkIfExists(fn, efn):
    if 0 >= os.path.getsize(fn):
        f = open(efn,'w')
        f.write('no output\n')
        f.close()

def parse_input(fname):
    """
    A function that takes in a filename,
    and returns a number corresponding to the selected interface button,
    and a dictionary of parameters for the Kernel object.
    """
    totalview = 0
    lnumber = 0
    f = open(fname,'r')
    line = f.readline().rstrip()
    lnumber +=1
    # first line, to test if we have something appropriate
    if line != "python command input":
        sys.exit(4)
    # which button was pressed
    lnumber +=1
    selcom = int(f.readline().rstrip())
    # now the actual parameters
    params = {}
    params["Choppers"] = {}
    params["Sample"] = {}
    params["Field"] = {}
    params["View"] = {}
    params["Lambda"] = {}
    params["hkl"] = {}
    instrument = {}
    instrument['Detectors'] = {}
    ### Wavelength resolution
    lnumber +=1
    a = f.readline().split()
    if len(a) <= 0:
        params["Lambda"]["Res"] = ""
    else:
        params["Lambda"]["Res"] = a[0]
    ### Wavelength min max
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 2):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    elif not (("NOT" in a[0]) or ("USED" in a[1])):
        params["Lambda"]["Min"] = a[0]
        params["Lambda"]["Max"] = a[1]
    ### magnetic field direction
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 1):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        if "T" in  a[0]:
            params["Field"]["Direction"] = 0
            totalview = 1
        else:
            params["Field"]["Direction"] = a[0]
    ### Sample constants
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["Constants"] = " ".join(a)
    # Sample angles
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["Angles"] = " ".join(a)
    # u
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["u"] = " ".join(a)
    # v
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["v"] = " ".join(a)
    # sample rotation
    a = f.readline().split()
    if len(a) == 3:
        params["Sample"]["phi"] = a[0]
        params["Sample"]["chi"] = a[1]
        params["Sample"]["omega"] = a[2]
    # H K L
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        if 'h' in a[0]:
            params["hkl"]["h"] = 'h'
        else:
            params["hkl"]["h"] = a[0]
        if 'k' in a[1]:
            params["hkl"]["k"] = 'k'
        else:
            params["hkl"]["k"] = a[1]
        if 'l' in a[2]:
            params["hkl"]["l"] = 'l'
        else:
            params["hkl"]["l"] = a[2]
    # markers
    prec = f.readline()
    config = f.readline().split()
    if config[0] == 's':
        instrument['Guide'] = 'Short'
    elif config[0] == 'l':
        instrument['Guide'] = 'Long'
    else:
        instrument['Guide'] = 'SANS'
    if config[1] == 'u':
        instrument['Cryostat'] = 'Front'
    elif config[1] == 'd':
        instrument['Cryostat'] = 'Back'
    else:
        instrument['Cryostat'] = 'None'
    if config[2] == 'd':
        instrument['Detectors']['Forward'] = 'Fixed'
    else:
        instrument['Detectors']['Forward'] = 'SANS'
    if config[3] == 's':
        instrument['Detectors']['Backward'] = 'Symmetrical'
    else:
        instrument['Detectors']['Backward'] = 'Left side'
    config = f.readline()
    instrument['Detectors']['Active'] = []
    if '1' in config:
        instrument['Detectors']['Active'].append(True)
    else:
        instrument['Detectors']['Active'].append(False)
    if '2' in config:
        instrument['Detectors']['Active'].append(True)
    else:
        instrument['Detectors']['Active'].append(False)
    if '3' in config:
        instrument['Detectors']['Active'].append(True)
    else:
        instrument['Detectors']['Active'].append(False)
    if '4' in config:
        instrument['Detectors']['Active'].append(True)
    else:
        instrument['Detectors']['Active'].append(False)
    if '5' in config:
        instrument['Detectors']['Active'].append(True)
    else:
        instrument['Detectors']['Active'].append(False)
    if '6' in config:
        instrument['Detectors']['Active'].append(True)
    else:
        instrument['Detectors']['Active'].append(False)
    markers = []
    for i in range(5):
        a = f.readline()
        if a.__len__() <= 0:
            break
        markers.append(a)
    f.close()
    return selcom, params, markers, prec, totalview, instrument

if __name__ == '__main__':
    # take command line arguments
    comfn = sys.argv[1]
    if len(sys.argv) > 2:
        resdir = sys.argv[2]
    else:
        resdir = ""

    if resdir == "":
        resdir = "."
    elif not os.path.exists(resdir):
        sys.exit(2)

    f = open(comfn,'r')

    line = f.readline().rstrip()
# first line, to test if we have something appropriate
    if line != "python command input":
        sys.exit(4)

### added more values to unpack here
    selcom, params, markers, prec, totalview, instrument = parse_input(comfn)

    kernel = Kernel()
    kernel.take_parameters(params)
    kernel.marker_points(markers)
    kernel.set_precision(prec)

# writes out the all the parameters after parsing
    kernel.current_parameters_str(filename = "current_parameters.txt")

    kernel.take_instrument(instrument)

# generate the result file(s)
    instfn = resdir + "/inst.png"
    map1fn = resdir + "/maps.png"
    det1fn = resdir + "/dets.png"
    errfn  = resdir + "/err.txt"

    if selcom == 1:
        kernel.show_instrument(instfn)
        checkIfExists(pngfn, errfn)
    elif selcom == 2:
        if totalview:
            kernel.show_total_coverage(map1fn)
        else:
            kernel.show_planes_both(map1fn)
        checkIfExists(map1fn, errfn)
# a new option here!
    elif selcom == 3:
        kernel.show_detector_panels(det1fn)
        checkIfExists(det1fn, errfn)
    else:
        kernel.show_instrument(instfn)
        if totalview:
            kernel.show_total_coverage(map1fn)
        else:
            kernel.show_planes_both(map1fn)
        kernel.show_detector_panels(det1fn)
        checkIfExists(det1fn, errfn)
        checkIfExists(map1fn, errfn)
        checkIfExists(instfn, errfn)
        checkIfExists(map1fn, errfn)

