#    This file is part of EXEQ.
#
#    EXEQ is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.
# 
# Copyright (C) Maciej Bartkowiak, 2014-2018, 2020

__doc__ = """
This file contains the definition of objects shadowing the detectors.
It is to be parsed togeter with the detector positions for the instrument
definition.

Coding of the shadowing elements:
t - top
b - bottom
l - left
r - right
c - cone, i.e. things inside the cone are shadowed
s - stop, i.e. beamstop, not relative to the magnet
s - guide, i.e. like the beamstop, not relative to the magnet


NEW on 04 Nov 2014, Maciej Bartkowiak
"""

from geometry import *

# for forward scattering, we use only
# the beamstop as the limits
forward = [
["s", np.arctan(8.0/150.0)],
["X", (0.164, -0.27, -0.182, 0.2025)] # top, bottom, left, right
]

beamstop = [
["X", (0.164, -0.27, -0.182, 0.2025)] # top, bottom, left, right
]

chopper_housing = [
["X", (2.0, -2.0, -0.6, 0.6)] # top, bottom, left, right
]

backward = [
["t", np.arctan(9.35/93.15)],
["g", np.arctan(100.00/2000.0)],
["X", (2.0, -2.0, -0.6, 0.6)] # top, bottom, left, right
]

extra = [
#["g", np.arctan(100.00/2000.0)],
#["t", np.arctan(9.35/93.15)],
["lr", np.arctan(129.93/573.3)],
["lr", np.arctan(396.93/1858.3)],
["tb", np.arctan(49.92/573.3)],
["tb", np.arctan(247.08/1858.3)]
]

cryostat_outer = np.array([
[-396.0, 247.0, -1846.0],
[-297.0, -347.0, -1846.0],
[297.0, -347.0, -1846.0],
[396.0, 247.0, -1846.0]
])

cryostat_inner = np.array([
[127.0, 47.0, -546.0],
[127.0, -47.0, -546.0],
[-127.0, -47.0, -546.0],
[-127.0, 47.0, -546.0]
])

cryostat_outer_fw = np.array([
[-396.0, 247.0, 1846.0],
[-297.0, -347.0, 1846.0],
[297.0, -347.0, 1846.0],
[396.0, 247.0, 1846.0]
])

cryostat_inner_fw = np.array([
[127.0, 47.0, 546.0],
[127.0, -47.0, 546.0],
[-127.0, -47.0, 546.0],
[-127.0, 47.0, 546.0]
])


# new_cryostat = [
# ['c', radius = 140.0, distance = 1846.0 - 1264.0],
# ['c', radius = 468.0, distance = 1846.0],
# ['t', topedge= 206.0, distance = 1846.0],
# ['t', topedge= 76.0 - 20.0, distance = 1846.0 - 1264.0]
# ]


