#!/usr/bin/python

#    This file is part of EXEQ.
#
#    EXEQ is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.
# 
# Copyright (C) Maciej Bartkowiak, 2014-2018, 2020

__doc__ = """
Create a png or x3d file for EXED (E,q)-range visualisation with python:
usage:
    pyexe.py parameterfile [result_directory]
Parameters are read from a text file,
the result file name are result_directory + res.png or res.x3d respective
"""

import os
import sys
# import volume
from geometry import *
from units import *
from persistence_agg import Kernel

### reading float values from file

def read_f(f):
    return float(f.readline().rstrip())

def read_fa(f):
    a = []
    for i in f.readline().rstrip().split():
        a.append(float(i))
    return np.array(a)

def checkIfExists(fn, efn):
    if 0 >= os.path.getsize(fn):
        f = open(efn,'w')
        f.write('no output\n')
        f.close()

def parse_input(fname):
    """
    A function that takes in a filename,
    and returns a number corresponding to the selected interface button,
    and a dictionary of parameters for the Kernel object.
    """
    lnumber = 0
    f = open(comfn,'r')
    line = f.readline().rstrip()
    lnumber +=1
    # first line, to test if we have something appropriate
    if line != "python command input":
        sys.exit(4)
    # which button was pressed
    lnumber +=1
    selcom = int(f.readline().rstrip())
    # now the actual parameters
    params = {}
    params["Choppers"] = {}
    params["Sample"] = {}
    params["Field"] = {}
    params["View"] = {}
    params["Lambda"] = {}
    params["hkl"] = {}
    ###
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 1):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Choppers"]["Frequency"] = float(a[0])
    ###
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 1):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Choppers"]["Suppression"] = int(float(a[0]))
    ### Wavelength parameters now
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 2):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    elif not (("NOT" in a[0]) or ("USED" in a[1])):
        params["Lambda"]["Min"] = float(a[0])
        params["Lambda"]["Max"] = float(a[1])
    # possibility of 2 kinds of wavelength input
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 2):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    elif not (("NOT" in a[0]) or ("USED" in a[1])):
        w, m = float(a[1]), float(a[0])
        params["Lambda"]["Min"] = m - w/2.0
        params["Lambda"]["Max"] = m + w/2.0
    ### Now the field direction
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 1):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Field"]["Direction"] = int(float(a[0]))
    ### Sample definition:
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["Constants"] = np.array([float(x) for x in a])
    #
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["Angles"] = np.array([float(x) for x in a])
    #
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["Angles"] = np.array([float(x) for x in a])
    #
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["u"] = np.array([float(x) for x in a])
    #
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        params["Sample"]["v"] = np.array([float(x) for x in a])
    # The h, k, l values
    lnumber +=1
    a = f.readline().split()
    if not (len(a) == 3):
        print( "Wrong input in line ", str(lnumber))
        sys.exit(4)
    else:
        if 'h' in a[0]:
            params["hkl"]["h"] = 'h'
        else:
            params["hkl"]["h"] = float(a[0])
        if 'k' in a[1]:
            params["hkl"]["k"] = 'k'
        else:
            params["hkl"]["k"] = float(a[1])
        if 'l' in a[2]:
            params["hkl"]["l"] = 'l'
        else:
            params["hkl"]["l"] = float(a[2])
    # NEW: Now the markers
    markers = []
    for i in range(5):
        a = f.readline()
        markers.append(a)
    prec = f.readline()
    f.close()
    return selcom, params, markers, prec


params = {}
params["Choppers"] = {}
params["Sample"] = {}
params["Field"] = {}
params["Lambda"] = {}
params["hkl"] = {}
params["Field"]["Direction"] = '2.0'
params["Choppers"]["Frequency"] = '120'
params["Choppers"]["Suppression"] = '1'
params["Lambda"]["Res"] = ""
params["Lambda"]["Min"] = '0.7'
params["Lambda"]["Max"] = '7.9'
params["Sample"]["Constants"] = "4.0, 4.0, 4.0"
params["Sample"]["Angles"] = "90.0, 90.0, 90.0"
params["Sample"]["u"] = "1.0, 0.0, 0.0"
params["Sample"]["v"] = "0.0, 1.0, 0.0"
params["Sample"]["phi"] = '3.0'
params["Sample"]["chi"] = '0'
params["Sample"]["omega"] = '4.5'
params["hkl"]["h"] = 'h'
params["hkl"]["k"] = '-2:2'
params["hkl"]["l"] = '-0.01'
markers = []
prec = '2'

## Next lines are subject of change, which should be negotiated
## We expect 3 groups of input lines
## Instrument: Chopper freq., Suppression rate, Wavelength range center, Wvl rng bandwidth, Mag. field dir.
## Sample: Lattice constants, Latt. angles, Orient. u, Orient. v
## View: Reflection index, Plane normal, Plane origin
#
#params["Choppers"]["Frequency"] = read_f(f)
#params["Choppers"]["Suppression"] = read_f(f)
#params["Lambda"]["Mean"] = read_f(f)
#params["Lambda"]["Width"] = read_f(f)
#params["Field"]["Direction"] = read_f(f)
#params["Sample"]["Constants"] = read_fa(f)
#params["Sample"]["Angles"] = read_fa(f)
#params["Sample"]["u"] = read_fa(f)
#params["Sample"]["v"] = read_fa(f)
#params["View"]["hkl"] = read_fa(f)
#params["View"]["plane_normal"] = read_fa(f)
#params["View"]["plane_origin"] = read_fa(f)
#
#f.close()

# markers = ['0.2, 0.3, 0.0', '-0.2, -1.0, 0.0', '-0.05, 0.5, 0.0']

kernel = Kernel()
kernel.take_parameters(params)
kernel.marker_points(markers)
kernel.set_precision(prec)

# writes out the all the parameters after parsing
kernel.current_parameters_str(filename = "current_parameters.txt")
kernel.chopper_freqs()

params["Sample"]["phi"] = '0'
params["Sample"]["chi"] = '0'
params["Sample"]["omega"] = '0'
kernel.take_parameters(params)
kernel.chopper_freqs()
kernel.show_planes_both("flat_test0_15deg_new.png")

params["Sample"]["phi"] = '0'
params["Sample"]["chi"] = '0'
params["Sample"]["omega"] = '45'
kernel.take_parameters(params)
kernel.chopper_freqs()
kernel.show_planes_both("flat_test1_15deg_new.png")

params["Sample"]["phi"] = '30.0'
params["Sample"]["chi"] = '0'
params["Sample"]["omega"] = '0'
kernel.take_parameters(params)
kernel.chopper_freqs()
kernel.show_planes_both("flat_test2_15deg_new.png")

params["Sample"]["phi"] = '30.0'
params["Sample"]["chi"] = '0'
params["Sample"]["omega"] = '45'
kernel.take_parameters(params)
kernel.chopper_freqs()
kernel.show_planes_both("flat_test3_15deg_new.png")
kernel.show_detector_panels("panels_test1.png")


