#    This file is part of EXEQ.
#
#    EXEQ is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.
# 
# Copyright (C) Maciej Bartkowiak, 2014-2018, 2020

__doc__ = """
Very basic functions for reading and writing number arrays
from and into files.
Maciej Bartkowiak, 28 Mar 2014
"""

import numpy as np

def write_array(array,filename):
    """
    This function takes a numpy array and outputs it
    into a file as a table in plain text.
    """
    target = open(filename,'w')
    for i in array:
        # target.write(str(i).strip('[]').strip() + "\n")
        target.write(" ".join([str(j) for j in i]) + "\n")
    return 1

def read_numbers(filename,separator=" "):
    """
    Reads any file with columns of numbers and turns it
    into a numpy array.
    """
    temp = []
    f = open(filename,'r')
    line = f.readline()
#    while (line.split(separator)):
    while (line.split()):
        if '#' in line.split()[0]:
            line = f.readline()
        else:
            temp1 = []
#        for i in line.split(separator):
            for i in line.split():
                temp1.append(float(i))
            temp.append(temp1)
            line = f.readline()
    return np.array(temp)

def parse_input_2018(fname):
    """
    A function that takes in a filename,
    and returns a number corresponding to the selected interface button,
    and a dictionary of parameters for the Kernel object.
    """
    lnumber = 0
    f = open(fname,'r')
    line1 = f.readline().rstrip()
    lnumber +=1
    line2 = f.readline().rstrip()
    lnumber +=1
    # first line, to test if we have something appropriate
    if line2 != "python graphic interface" or not "exeq" in line1:
        print("Wrong input file format, will not proceed.")
        return None
        # sys.exit(4)
    # which button was pressed
    lnumber +=1
    # now the actual parameters
    params = {}
    params["Choppers"] = {}
    params["Sample"] = {}
    params["Field"] = {}
    params["View"] = {}
    params["Lambda"] = {}
    params["hkl"] = {}
    markers = []
    instrument = {}
    instrument['Detectors'] = {}
    for nline in f:
        uncommented = nline.split('#')[0]
        sides = uncommented.split(':')
        if "python graphic interface" in sides[0]:
            continue
        elif 'wavelength_resolution' in sides[0]:
            params["Lambda"]["Res"] = sides[1]
        elif 'wavelength_range_minimum' in sides[0]:
            params["Lambda"]["Min"] = sides[1]
        elif 'wavelength_range_maximum' in sides[0]:
            params["Lambda"]["Max"] = sides[1]
        elif 'lattice_constants' in sides[0]:
            params["Sample"]["Constants"] = sides[1]
        elif 'lattice_angles' in sides[0]:
            params["Sample"]["Angles"] = sides[1]
        elif 'orientation_vector_bu' in sides[0]:
            params["Sample"]["u"] = sides[1]
        elif 'orientation_vector_bv' in sides[0]:
            params["Sample"]["v"] = sides[1]
        elif 'abmfdaib' in sides[0]:
            params["Field"]["Direction"] = sides[1]
        elif sides[0] == 'rotation_bu':
            params["Sample"]["phi"] = sides[1]
        elif sides[0] == 'rotation_bv':
            params["Sample"]["chi"] = sides[1]
        elif sides[0] == 'rotation_bubv':
            params["Sample"]["omega"] = sides[1]
        elif sides[0] == 'h':
            params["hkl"]["h"] = ":".join(sides[1:])
        elif sides[0] == 'k':
            params["hkl"]["k"] = ":".join(sides[1:])
        elif sides[0] == 'l':
            params["hkl"]["l"] = ":".join(sides[1:])
        elif 'point' in sides[0]:
            if ',' in sides[1]:
                temp = sides[1].split(',')
            else:
                temp = sides[1].split(' ')
            markers.append(" ".join(temp))
        elif 'precision' in sides[0]:
            prec = sides[1]
        elif 'guide' in sides[0]:
            instrument['Guide'] = sides[1]
        elif 'cryostat' in sides[0]:
            instrument['Cryostat'] = sides[1]
        elif 'forward_detectors' in sides[0]:
            instrument['Detectors']['Forward'] = sides[1]
        elif 'backward_detectors' in sides[0]:
            instrument['Detectors']['Backward'] = sides[1]
        elif 'button' in sides[0]:
            if "orientation" in sides[1]:
                selcom = 'orientation'
            elif "detector" in sides[1]:
                selcom = 'detector'
            elif "compute_graphic_output" in sides[1]:
                selcom = 'map'
            elif "total_coverage" in sides[1]:
                selcom = 'total'
            else:
                selcom = "Completely irrelevant, since you are running standalone"
        else:
            print('Unknown input parameter: ', sides[0], " in line ", str(lnumber))
        lnumber += 1
    f.close()
    return selcom, params, markers, prec, instrument


